twoord.plot             package:plotrix             R Documentation

_P_l_o_t _w_i_t_h _t_w_o _o_r_d_i_n_a_t_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Two sets of values are displayed on the same plot with different
     ordinate scales on the left and right.

_U_s_a_g_e:

      twoord.plot(lx,ly,rx,ry,data=NULL,xlim=NULL,lylim=NULL,rylim=NULL,
      mar=NULL,lcol=1,rcol=2,xlab="",ylab="",rylab="",lpch=1,rpch=2,
      type="b",...)

_A_r_g_u_m_e_n_t_s:

lx,ly,rx,ry: y and optional x values for the plot

    data: an optional data frame from which to obtain the above values

    xlim: optional x limits as in 'plot'

lylim,rylim: optional y limits for the left and right axes respectively

     mar: optional margin adjustment, defaults to 'c(5,4,4,4)'

lcol,rcol: colors to distinguish the two sets of values

xlab,ylab: axis labels as in 'plot'

   rylab: label for the right axis

lpch,rpch: plot symbols to distinguish the two sets of values

    type: as in 'plot'

     ...: additional arguments passed to 'axis'.

_D_e_t_a_i_l_s:

     'twoord.plot' automates the process of displaying two sets of
     values that have different ranges on the same plot. It is
     principally useful in illustrating some relationship between the
     values across the observations.

     It is best to pass all the arguments 'lx, ly, rx, ry', but the
     function will attempt to substitute sensible x values if one or
     two are missing.

_V_a_l_u_e:

     nil

_N_o_t_e:

     It may be useful to consider 'gap.plot' as an alternative.

_A_u_t_h_o_r(_s):

     Jim Lemon

_S_e_e _A_l_s_o:

     'plot'

_E_x_a_m_p_l_e_s:

      twoord.plot(2:10,seq(3,7,by=0.5)+rnorm(9),
       1:15,rev(60:74)+rnorm(15),xlab="Sequence",
       ylab="Ascending values",rylab="Descending values",
       main="Test of twoord.plot")

