### Name: color2D.matplot
### Title: Display a numeric matrix as color matrix
### Aliases: color2D.matplot
### Keywords: misc

### ** Examples

 x<-matrix(rnorm(1024)+sin(seq(0,2*pi,length=1024)),nrow=32)
 if(dev.interactive()) par(ask=TRUE)
 color2D.matplot(x,c(1,0),c(0,0),c(0,1),show.legend=TRUE,
  xlab="Columns",ylab="Rows",main="2D matrix plot")
 # now do hexagons
 color2D.matplot(x,c(1,0),c(0,0),c(0,1),show.legend=TRUE,
  xlab="Columns",ylab="Rows",do.hex=TRUE,main="2D matrix plot (hexagons)")
 # do a color only association plot
 xt<-table(sample(1:10,100,TRUE),sample(1:10,100,TRUE))
 observed<-xt[,rev(1:dim(xt)[2])]
 expected<-outer(rowSums(observed),colSums(observed),"*")/sum(xt)
 deviates<-(observed-expected)/sqrt(expected)
 color2D.matplot(x=round(deviates,2),redrange=c(1,0.5,0),
  greenrange=c(0,0.5,0),bluerange=c(0,1),
  show.values=TRUE,main="Association plot")
 par(ask=FALSE)



