### Name: fan.plot
### Title: Display a fan plot.
### Aliases: fan.plot
### Keywords: misc

### ** Examples

 # IUCN counts of threatened species by geographical area
 iucn.df<-data.frame(area=c("Africa","Asia","Europe","N&C America",
  "S America","Oceania"),threatened=c(5994,7737,1987,4716,5097,2093))
 labelpos<-fan.plot(iucn.df$threatened,
  labels=paste(iucn.df$area,iucn.df$threatened,sep="-"),
  main="Threatened species by geographical area",ticks=276)
 # give the "Africa" label a bit more space with labelpos
 labelpos[2]<-1.1
 fan.plot(iucn.df$threatened,
  labels=paste(iucn.df$area,iucn.df$threatened,sep="-"),
  labelpos=labelpos,
  main="Threatened species by geographical area",ticks=276)
 # now do it with label.radius
 fan.plot(iucn.df$threatened,
  labels=paste(iucn.df$area,iucn.df$threatened,sep="-"),
  label.radius=c(1.15,1.2,1.2,1.2,1.2,1.2),
  main="Threatened species by geographical area",ticks=276)



