### Name: gap.plot
### Title: Display a plot with one or two gaps (missing ranges) on one axis
### Aliases: gap.plot
### Keywords: misc

### ** Examples

 twogrp<-c(rnorm(5)+4,rnorm(5)+20,rnorm(5)+5,rnorm(5)+22)
 gpcol<-c(2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5)
 gap.plot(twogrp,gap=c(8,16),xlab="Index",ylab="Group values",
  main="Plot gap on Y axis",col=gpcol)
 gap.plot(twogrp,rnorm(20),gap=c(8,16),gap.axis="x",xlab="X values",
  xtics=c(4,7,17,20),ylab="Y values",main="Plot gap on X axis") 
threegrp <- c(twogrp,rnorm(10)+40)
gap.plot(threegrp,gap=c(8,16,25,35),
 xlab="X values",ylab="Y values",
 main="Test two gap plot",
 ytics=c(4,6,18,20,22,38,40),
 pch=c(rep(2,10),rep(3,10),rep(4,10)),
 col=c(rep(2,10),rep(3,10),rep(4,10)))


