### Name: radial.plot
### Title: Plot values on a circular grid of 0 to 2*pi radians.
### Aliases: radial.plot
### Keywords: misc

### ** Examples

 testlen<-rnorm(10)*2+5
 testpos<-seq(0,18*pi/10,length=10)
 testlab<-letters[1:10]
 radial.plot(testlen,testpos,main="Test Radial Lines",line.col="red",lwd=3)
 if(dev.interactive()) par(ask=TRUE)
 testlen<-c(sin(seq(0,1.98*pi,length=100))+2+rnorm(100)/10)
 testpos<-seq(0,1.98*pi,length=100)
 radial.plot(testlen,testpos,rp.type="p",main="Test Polygon",line.col="blue")
 # now do a 12 o'clock start with clockwise positive
 radial.plot(testlen,testpos,start=pi/2,clockwise=TRUE,
  rp.type="s",main="Test Symbols (clockwise)",
  point.symbols=16,point.col="green",show.centroid=TRUE)
 par(ask=FALSE)



