### Name: create.baseline.complete
### Title: Create a baseline population of related individuals
### Aliases: create.baseline.complete
### Keywords: datagen

### ** Examples


## Not run: 
##D The syntax below constructs the baseline population for the
##D calendar year 1955 (baseyear). It applies the 1955 fertility
##D and mortality rates for 70 years (runintime) to the virtual
##D population of 1855 constructed from the 1955 age profile; the
##D 1855 population consists of 3000 females and approximately
##D 3000 males (base.scale), all unrelated individuals. Incident
##D cancer is assigned during the creation (healthy), but there is
##D no familial risk of cancer (risk). The mortality ratio for cases
##D is 2 (mortratio). The resulting population is not saved to file
##D (print.option). The input files are "populationfem.txt",
##D "populationmale.txt", "mortalityfem.txt", "mortalitymale.txt",
##D "fertility.txt" and "incidence.txt" from the "data" folder of the
##D poplab package.
## End(Not run)

base <- 
create.baseline.complete(baseyear = 1955, healthy = 0, risk =
1, mortratio = 2, d.mod = "rr", fam.rel = "p", base.scale = 
30, runintime = 70, print.option = FALSE, population.fem = 
"populationfem.txt", population.male = "populationmale.txt", 
mortality.fem = "mortalityfem.txt", mortality.male = 
"mortalitymale.txt", fertility = "fertility.txt", incidence = 
"incidence.txt", seed = 52482337, folder =
system.file("data", package = "poplab"))

## Not run: 
##D In the syntax below the familial relative risk (d.mod) depends
##D on maternal (fam.rel) age at incidence: the risk of disease (risk)
##D is increased by factor of 4 for women whose mothers where strictly 
##D younger than 50 years of age at diagnosis compared to daughters 
##D of unaffected mothers, and by a factor of 2 for daughters of 
##D women diagnosed between the age of 50 to 100 years.
##D 
##D base <- 
##D create.baseline.complete(baseyear = 1955, healthy = 0, risk =
##D c(50, 101, 4, 2), mortratio = 2, d.mod = "agesprr", fam.rel =
##D "p", base.scale = 30, runintime = 70, print.option = FALSE, 
##D population.fem = "populationfem.txt", population.male = 
##D "populationmale.txt", mortality.fem = "mortalityfem.txt", 
##D mortality.male = "mortalitymale.txt", fertility = 
##D "fertility.txt", incidence = "incidence.txt",
##D seed = 52482337, folder =
##D system.file("data", package = "poplab"))
## End(Not run)




