### Name: plot.poplab
### Title: Plot the age profile of a simulated population
### Aliases: plot.poplab
### Keywords: aplot methods

### ** Examples


## Not run: 
##D For the following examples it is necessary to load the simpop
##D object or to use the simped function and assign the result to
##D a variable called 'simpop'.
## End(Not run)

## load simulate the population for the calendar period 1955-2002:

load (file = file.path(system.file("data", package = "poplab"), 
"simpop.Rdata"))

## plot the simulated population versus the real population
## for the calendar year 1990:
plot.poplab(x = simpop, option = "current", population.fem =
"populationfem.txt", population.male = "populationmale.txt",
year = 1990, folder =
system.file("data", package = "poplab")) 

## plot the baseline population versus the real population
## for the calendar year 1955:
plot.poplab(x = simpop, option = "base", population.fem =
"populationfem.txt", population.male = "populationmale.txt",
year = 1955, folder =
system.file("data", package = "poplab")) 




