### Name: print.poplab
### Title: Save to file a simulated population
### Aliases: print.poplab
### Keywords: methods

### ** Examples


## Not run: 
##D For these examples it is necessary to use the simped function
##D and assign the result to a variable called 'simpop'.
## End(Not run)

## simulate the population for the calendar period 1955-2002:
simpop <- 
simped(baseyear = 1955, basehealth = 0, basefamrisk = 2, 
sex.a = 2, endyear = 2002, healthy = 0, famrisk = 2, 
mortratio = 2, d.mod = "rr", fam.rel = "p", print.option = 
FALSE, population.fem = "populationfem.txt", population.male = 
"populationmale.txt", mortality.fem = "mortalityfem.txt", 
mortality.male = "mortalitymale.txt", fertility = 
"fertility.txt", incidence = "incidence.txt", seed = 
52482337, folder = system.file("data", package = "poplab"))

## save the population simulated up to the calendar year 1990
## (although the simped function simulated the population up
## to the year 2002); the name of the created file will be
## 'simpop_endYr_1990.txt'
print.poplab(simpop, "current", year = 1990, folder =
system.file("data", package = "poplab"))

## save the 1955 baseline population to a file named
## "base_pop_1955.txt"  
print.poplab(simpop, "base", year = 1955, folder =
system.file("data", package = "poplab"))




