### Name: simped
### Title: Simulate the evolution of a population of related individuals
###   over a calendar period
### Aliases: simped
### Keywords: datagen

### ** Examples


## Not run: 
##D The syntax below will search into the specified folder for a
##D file called 'base_pop_1955.txt' (see Details). If the file
##D is found, it is read-in as the baseline population. If it is
##D not found, an implicit call to the create.baseline.complete
##D function is made as follows:
##D 
##D create.baseline.complete(baseyear = 1955, healthy = 0, risk =
##D 2, sex.a = 2, base.scale = 50, runintime = 70, d.mod = 
##D "rr", fam.rel = "p", print.option = FALSE, population.fem = 
##D "populationfem.txt", population.male = "populationmale.txt", 
##D mortality.fem = "mortalityfem.txt", mortality.male = 
##D "mortalitymale.txt", fertility = "fertility.txt", incidence = 
##D "incidence.txt", seed = 52482337, folder =
##D system.file("data", package = "poplab"))
##D 
##D Next the evolution of this baseline population is simulated
##D over the calendar period 1955 - 1985 ([baseyear, endyear]).
##D Incident cancer is assigned (healthy) to the female population
##D (sex.a) via a model of familial relative risk (d.mod), where the 
##D risk ratio for women with an affected mother (fam.rel) is 2 (famrisk). 
##D The mortality ratio for cases is 2 (mortratio). The resulting 
##D pedigree is not saved to file (print.option). The input files 
##D are "populationfem.txt", "populationmale.txt", "mortalityfem.txt", 
##D "mortalitymale.txt", "fertility.txt" and "incidence.txt" from the "data"
##D folder of the poplab package.
## End(Not run)

simpop <- 
simped(baseyear = 1955, basehealth = 0, basefamrisk = 2,
sex.a = 2, basetotal = 50, warmuptime = 70, endyear = 1985,
healthy = 0, famrisk = 2, mortratio = 2, d.mod = "rr", 
fam.rel = "p", print.option = FALSE, population.fem = 
"populationfem.txt",  population.male = "populationmale.txt", 
mortality.fem = "mortalityfem.txt", mortality.male = 
"mortalitymale.txt", fertility = "fertility.txt", incidence = 
"incidence.txt", seed = 52482337,
folder = system.file("data", package = "poplab"))

## resulting baseline population
base <- simpop[[1]]

## resulting evolved population
evolved <- simpop[[2]]

## Not run: 
##D In the syntax below the familial relative risk (d.mod) depends
##D on maternal (fam.rel) age at incidence: the risk of disease (risk) 
##D is increased by factor of 4 for women whose mothers where strictly 
##D younger than 50 years of age at diagnosis compared to daughters 
##D of unaffected mothers, and by a factor of 2 for daughters of 
##D women diagnosed between the age of 50 to 100 years.
##D 
##D simpop <- 
##D simped(baseyear = 1955, basehealth = 0, basefamrisk = 
##D c(50, 101, 4, 2), sex.a = 2, basetotal = 50, warmuptime = 
##D 70, endyear = 1985, healthy = 0, famrisk = c(50, 101, 4, 2), 
##D mortratio = 2, d.mod = "agesprr", fam.rel = "p", print.option = 
##D FALSE, population.fem = "populationfem.txt", population.male = 
##D "populationmale.txt", mortality.fem = "mortalityfem.txt", 
##D mortality.male = "mortalitymale.txt", fertility = 
##D "fertility.txt", incidence = "incidence.txt", 
##D seed = 52482337,
##D folder = system.file("data", package = "poplab"))
## End(Not run)




