### Name: prim.box
### Title: PRIM for multivariate data
### Aliases: prim.box prim.hdr prim.combine
### Keywords: multivariate

### ** Examples

n <- 1000
set.seed(88192)

mus.p <- rbind(c(0,0), c(2,0), c(1, 2), c(2.5, 2))
Sigmas.p <- 0.125*rbind(diag(2), diag(c(0.5, 0.5)),
   diag(c(0.125, 0.25)), diag(c(0.125, 0.25))) 
props.p <- c(0.5, 0.25, 0.125, 0.125)

mus.n <- rbind(c(0,0), c(2,0), c(2.5, 2))
Sigmas.n <- 0.125*rbind(matrix(c(1,-0.6,-0.6,1), nrow=2),
   diag(c(0.5, 0.5)),diag(c(0.125, 0.25))) 
props.n <- c(0.625, 0.25, 0.125)

x.p <- rmvnorm.mixt(n, mus.p, Sigmas.p, props.p)
x.n <- rmvnorm.mixt(n, mus.n, Sigmas.n, props.n)
x <- rbind(x.p, x.n)
y <- c(rep(1, nrow(x.p)), rep(-1, nrow(x.n)))
  ## 1 = positive sample, -1 = negative sample

y.thr <- c(1, -0.35)

## using only one command

x.prim1 <- prim.box(x=x, y=y, threshold=y.thr, threshold.type=0)

## alternative - requires more commands but allows more control
## in intermediate stages

x.prim.hdr.p <- prim.box(x=x, y=y, threshold.type=1,
   threshold=1)

x.prim.n <- prim.box(x=x, y=y, threshold.type=-1)
summary(x.prim.n)
   ## threshold too high, try lower one

x.prim.hdr.n <- prim.hdr(x.prim.n, threshold=-0.35,
   threshold.type=-1)
x.prim2 <- prim.combine(x.prim.hdr.p, x.prim.hdr.n)
       
plot(x.prim2)

summary(x.prim1)
summary(x.prim2) ## should be exactly the same as command above



