### Name: printProfileCallGraph
### Title: Print Call Graph for Rprof Profile Data
### Aliases: printProfileCallGraph
### Keywords: programming utilities

### ** Examples

## Not run: 
##D      ## Rprof() is not available on all platforms
##D      Rprof(tmp <- tempfile())
##D      example(glm)
##D      Rprof()
##D      printProfileCallGraph(readProfileData(tmp))
##D      unlink(tmp)
##D 
##D      ## If you have graphviz and cgprof installed on a UNIX-like system
##D      ## then in R do:
##D 
##D      Rprof(tmp <- tempfile())
##D      example(glm)
##D      Rprof()
##D      printProfileCallGraph(readProfileData(tmp), "foo.graph")
##D 
##D      ## and then in a shell do (to use the interactive dotty):
##D 
##D      cgprof -TX foo.graph
##D 
##D      ## or (to create a postscript version and view with gv):
##D 
##D      cgprof -Tps foo.graph > foo.ps
##D      gv foo.ps
##D   
## End(Not run)



