### Name: correct.cor
### Title: Find dis-attenuated correlations and give alpha reliabilities
### Aliases: correct.cor
### Keywords: models multivariate

### ** Examples


# attitude from the datasets package
#example 1 is a rather clunky way of doing things
## Not run: 
##D a1 <- attitude[,c(1:3)]
##D a2 <- attitude[,c(4:7)]
##D x1 <- rowSums(a1)  #find the sum of the first 3 attitudes
##D x2 <- rowSums(a2)   #find the sum of the last 4 attitudes
##D alpha1 <- alpha.scale(x1,a1)
##D alpha2 <- alpha.scale(x2,a2)
##D x <- matrix(c(x1,x2),ncol=2)
##D x.cor <- cor(x)
##D alpha <- c(alpha1,alpha2)
##D round(correct.cor(x.cor,alpha),2)
##D #
##D #much better - although uses standardized alpha 
##D clusters <- matrix(c(rep(1,3),rep(0,7),rep(1,4)),ncol=2)
##D cluster.loadings(clusters,cor(attitude))
##D # or 
##D clusters <- matrix(c(rep(1,3),rep(0,7),rep(1,4)),ncol=2)
##D cluster.cor(clusters,cor(attitude))
##D #
##D #best
##D scores <- score.items(matrix(c(rep(1,3),rep(0,7),rep(1,4)),ncol=2),attitude)
##D scores$corrected
## End(Not run)





