VSS.plot                package:psych                R Documentation

_P_l_o_t _V_S_S _f_i_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     The Very Simple Structure criterion ( 'VSS') for estimating the
     optimal number of factors is plotted as a function of the
     increasing complexity and increasing number of factors.

_U_s_a_g_e:

     VSS.plot(x, title = "Very Simple Structure", line = FALSE)

_A_r_g_u_m_e_n_t_s:

       x: output from VSS 

   title: any title 

    line: connect different complexities 

_D_e_t_a_i_l_s:

     Item-factor models differ in their "complexity".  Complexity 1
     means that all except the greatest (absolute) loading for an item
     are ignored. Basically a cluster model (e.g., 'ICLUST').
     Complexity 2 implies all except the greatest two, etc.  

     Different complexities can suggest different number of optimal
     number of factors to extract.  For personality items, complexity 1
     and 2 are probably the most meaningful.

     The Very Simple Structure criterion will tend to peak at the
     number of factors that are most interpretable for a given level of
     complexity.  Note that some problems, the most interpretable
     number of factors will differ as a function of complexity.  For
     instance, when doing the Harman 24 psychological variable
     problems, an unrotated solution of complexity one suggests one
     factor (g), while a complexity two solution suggests that a four
     factor solution is most appropriate.  This latter probably
     reflects a bi-factor structure.  

     For examples of VSS.plot output, see <URL:
     http://personality-project.org/r/r.vss.html>

_V_a_l_u_e:

     A plot window showing the VSS criterion varying as the number of
     factors and the complexity of the items.

_A_u_t_h_o_r(_s):

     Maintainer: William Revelle revelle@northwestern.edu

_R_e_f_e_r_e_n_c_e_s:

     <URL: http://personality-project.org/r/r.vss.html>

_S_e_e _A_l_s_o:

     'VSS',  'ICLUST', 'omega'

_E_x_a_m_p_l_e_s:

     test.data <- Harman74.cor$cov
     my.vss <- VSS(test.data)         #suggests that 4 factor complexity two solution is optimal
     VSS.plot(my.vss,title="VSS of Holzinger-Harmon problem")                 #see the graphics window

