### Name: to.period
### Title: Convert OHLC data to lower periodicity
### Aliases: to.period to.weekly to.monthly to.quarterly to.yearly
### Keywords: utilities

### ** Examples

## Not run: 
##D # download daily US/EU exchange rate from
##D # the FRED system
##D getSymbols("DEXUSEU",src="FRED")
##D getSymbols("QQQQ",src="yahoo")
##D 
##D # look at the data : )
##D DEXUSEU   # univariate time series
##D QQQQ      # OHLC already
##D 
##D # now it's a yearly OHLC
##D dex1 <- to.yearly(DEXUSEU)
##D 
##D # first monthly, then to yearly
##D dex2 <- to.yearly(to.monthly(DEXUSEU))
##D 
##D identical(dex1,dex2) # it's the same!
##D 
##D q1 <- to.yearly(QQQQ)
##D q2 <- to.yearly(to.monthly(QQQQ))
##D 
##D # these don't match - sometimes dates
##D # are off depending on when cutoffs
##D # occur - so BE CAREFUL when converting
##D # a converted object!
##D identical(q1,q2)    
## End(Not run)



