### Name: SVMBench
### Title: SVM Benchmarking Data and Consensus Relations
### Aliases: SVM_Benchmarking_Classification SVM_Benchmarking_Regression
###   SVM_Benchmarking_Classification_Consensus
###   SVM_Benchmarking_Regression_Consensus
### Keywords: datasets

### ** Examples

data("SVM_Benchmarking_Classification")

## 21 data sets
names(SVM_Benchmarking_Classification)

## 17 methods
relation_domain(SVM_Benchmarking_Classification)

## select preferences
P <- sapply(SVM_Benchmarking_Classification, relation_is_preference)

## only the artifical data sets yield preferences
names(SVM_Benchmarking_Classification)[P]

## visualize them using Hasse diagrams
if (require("Rgraphviz"))
    plot(SVM_Benchmarking_Classification[P])

## Same for regression:
data("SVM_Benchmarking_Regression")

## 12 data sets
names(SVM_Benchmarking_Regression)

## 10 methods
relation_domain(SVM_Benchmarking_Regression)

## select preferences
P <- sapply(SVM_Benchmarking_Regression, relation_is_preference)

## only two of the artifical data sets yield preferences
names(SVM_Benchmarking_Regression)[P]

## visualize them using Hasse diagrams
if (require("Rgraphviz"))
    plot(SVM_Benchmarking_Regression[P])

## Consensus solutions:

data("SVM_Benchmarking_Classification_Consensus")
data("SVM_Benchmarking_Regression_Consensus")

## The solutions for the three families are not unique
print(SVM_Benchmarking_Classification_Consensus)
print(SVM_Benchmarking_Regression_Consensus)

## visualize the consensus preferences
if (require("Rgraphviz")) {
    plot(SVM_Benchmarking_Classification_Consensus$P)
    plot(SVM_Benchmarking_Regression_Consensus$P)
}

## in tabular style:
ranking <- function(x) rev(names(sort(relation_class_ids(x))))
sapply(SVM_Benchmarking_Classification_Consensus$P, ranking)
sapply(SVM_Benchmarking_Regression_Consensus$P, ranking)

## (prettier and more informative:)
relation_classes(SVM_Benchmarking_Classification_Consensus$P[[1]])



