### Name: charfun
### Title: Relation Characteristic Functions
### Aliases: relation_charfun
### Keywords: math

### ** Examples

## Relation 'a divides b':
divides <- function(a, b) b %% a == 0
R <- relation(domain = list(1 : 10, 1 : 10), charfun = divides)
R
## 'Recover' characteristic function:
"%|%" <- relation_charfun(R)

## Use it.
2 %|% 6
c(2, 3, 4) %|% 6
2 %|% c(2, 3, 6)

## This also works:
"%|%"(2, 6)
## (and generally does for arities > 2).



