### Name: probe
### Title: Probe a Data Frame for Values Corresponding to a Scoped
###   Aggregate
### Aliases: probe select
### Keywords: manip

### ** Examples

data(Theoph)
#What is the time of the maximum concentration within subject (per row)?
S <- scope(Theoph,'Subject')
T <- probe(Theoph,'conc',that='Time',scope=S)
U <- select('Time',from=Theoph,among=S,where='conc',is='max')
# The T and U vectors above are not the same. You would need to switch 'conc' and 'Time' in
# the select argument above to do the same thing. 



