### Name: broken.line
### Title: Fitted values for segmented relationships
### Aliases: broken.line
### Keywords: regression nonlinear

### ** Examples

set.seed(1234)
z<-runif(100)
y<-rpois(100,exp(2+1.8*pmax(z-.6,0)))
o<-glm(y~z,family=poisson)
o.seg<-segmented(o,seg.Z=~z,psi=list(z=.5))
par(mfrow=c(1,2))
plot(z,y)
points(z,broken.line(o.seg,link=FALSE),col=2,pch=20)
plot(z,broken.line(o.seg,link=TRUE),ylab="log(Fitted)")
point.psi(o.seg,"z",col=2,pch="x",bottom=FALSE)
    


