### Name: segmented
### Title: Segmented relationships in regression models
### Aliases: segmented segmented.lm segmented.glm
### Keywords: regression nonlinear

### ** Examples


set.seed(12)
xx<-1:100
zz<-runif(100)
yy<-2+1.5*pmax(xx-35,0)-1.5*pmax(xx-70,0)+15*pmax(zz-.5,0)+rnorm(100,0,2)
dati<-data.frame(x=xx,y=yy,z=zz)
out.lm<-lm(y~x,data=dati)
o<-segmented(out.lm,seg.Z=~x,psi=list(x=c(30,60)),
    control=seg.control(display=FALSE))
slope(o)

out.lm1<-lm(y~z,data=dati)
o1<-update(o,seg.Z=~x+z,psi=list(x=c(30,60),z=.3))

            


