### Name: sobol
### Title: Sobol Non-linear Sensitivity Analysis
### Aliases: sobol sobol.sobol93 tell.sobol.sobol93 print.sobol.sobol93
###   plot.sobol.sobol93 sobol.saltelli02 tell.sobol.saltelli02
###   print.sobol.saltelli02 plot.sobol.saltelli02
### Keywords: misc

### ** Examples

# Test case : the non-monotonic Sobol g-function

# The method of sobol requires 2 samples
# There are 8 factors, all following the uniform distribution
# on [0,1]

n <- 1000
x <- data.frame(matrix(nr = 2 * n, nc = 8))
for (i in 1:8)
  x[, i] <- runif(2 * n)

# sensitivity analysis

sa <- sobol(model = sobol.fun, x1 = x[1:n,], x2 = x[(n+1):(2*n),], max.order = 2, nboot = 100)
print(sa)
#plot(sa)



