### Name: srcpcc
### Title: Linear Sensitivity Analysis
### Aliases: srcpcc tell.srcpcc print.srcpcc plot.srcpcc
### Keywords: misc

### ** Examples

# linear model : Y = X1 + X2 + X3

model1 <- function(x) x[, 1] + x[, 2] + x[, 3]

# a 100-sample with X1 ~ U(0.5, 1.5)
#                   X2 ~ U(1.5, 4.5)
#                   X3 ~ U(4.5, 13.5)

n <- 100
x <- data.frame(X1 = runif(n, 0.5, 1.5),
                X2 = runif(n, 1.5, 4.5),
                X3 = runif(n, 4.5, 13.5))

# sensitivity analysis

sa <- srcpcc(model = model1, x = x, nboot = 100)
print(sa)
par(mfrow = c(1,2))
plot(sa, ask = FALSE)



