### Name: tell
### Title: Computation Of Sensitivity Indices When The Model Is External
### Aliases: tell
### Keywords: misc

### ** Examples

# Example of the FAST method
# (one should note the call with model = NULL)

sa <- fast(model = NULL, factors = 8, n = 1000)

# at this stage, only the design of experiment (sa$x) was generated
# the response is computed "manually":

y <- sobol.fun(sa$x) # at this place could be a
                     # call to an external code

# then, the sensitivity analysis:

tell(sa, y)
print(sa)

# Remark : because the model is a simple R function,
# this example is equivalent to :
## Not run: sa <- fast(model = sobol.fun, factors = 8, n = 1000)



