### Name: line.cis
### Title: Slope and elevation of a (standardised) major axis, with
###   confidence intervals
### Aliases: line.cis
### Keywords: models regression

### ** Examples

#load the leaflife data
data(leaflife)

#consider only the low rainfall sites:
leaf.low.rain=leaflife[leaflife$rain=='low',]

#estimate the SMA line for reserve vs coat
line.cis(log10(longev),log10(lma),data=leaf.low.rain)

#produce CI's for MA slope and elevation:
line.cis(log10(longev),log10(lma),data=leaf.low.rain, method='MA')



