shift.com               package:smatr               R Documentation

_T_e_s_t _f_o_r _n_o _m_e_a_n _s_h_i_f_t _a_l_o_n_g _a _c_o_m_m_o_n (_s_t_a_n_d_a_r_d_i_s_e_d) _m_a_j_o_r _a_x_i_s

_D_e_s_c_r_i_p_t_i_o_n:

     Test if several groups of observations have no shift in location
     along major axis or standardised major axis lines with a common
     slope.

_U_s_a_g_e:

     shift.com( y, x, groups, data = NULL, method = 'SMA', intercept = TRUE,
        V=array( 0, c( 2,2,length(unique(groups)) ) ), group.names=sort(unique(groups)) )

_A_r_g_u_m_e_n_t_s:

       y: The Y-variable for all observations (as a vector)

       x: The X-variable for all observations (as a vector)

  groups: Coding variable identifying which group each observation
          belongs to (as a factor or vector)

    data: (optional) data frame containing the data 

  method: The line fitting method:

          '_S_M_A' _o_r _1 standardised major axis (this is the default)

          '_M_A' _o_r _2 major axis

intercept: (logical) Whether or not the line includes an  intercept.

          _F_A_L_S_E no intercept, so the line is forced through the origin 

          _T_R_U_E an intercept is fitted (this is the default) 

       V: The estimated variance matrices of measurement error, for
          each group. This is a 3-dimensional array with measurement
          error in Y in the first row and column, error in X in the
          second row and column, and groups running along the third
          dimension. Default is that there is no measurement error.

group.names: (optional: rarely required). A vector containing the
          labels for `groups'. (Only actually useful for reducing
          computation time in simulation work). 

_D_e_t_a_i_l_s:

     Calculates a Wald statistic to test for no shift along several
     MA's or SMA's of common slope. This is done by testing for equal
     fitted axis means across groups.

     Note that this test is only valid if it is reasonable to assume
     that the axes for the different groups all have the same slope.

     The test assumes the following:

        1.  each group of observations was independently sampled

        2.  the axes fitted to all groups have a common slope

        3.  y and x are linearly related within each group

        4.  fitted axis scores independently follow a normal
           distribution with equal variance at all points along the
           line, within each group

     Note that we do not need to assume equal variance across groups,
     unlike in tests comparing several linear regression lines.

     The assumptions can be visually checked by plotting residuals
     against fitted axis scores, and by constructing a Q-Q plot of
     residuals against a normal distribution.  An appropriate residual
     variable is y-bx, and for fitted axis scores y+bx (for SMA) or
     by+lx (for MA or `lamest'), where b represents the common slope
     estimate, and l the error variance ratio. If there is a distinct
     increasing or decreasing trend within any of the groups, this
     suggests that all groups do not share a common slope.

     A plot of residual scores against fitted axis scores can also be
     used as a visual test for common elevation. If fitted axis scores
     systematically differ across groups then this is evidence of a
     shift along the common axis.

     The common slope (b) is estimated from a maximum of 100
     iterations, convergence is reached when the change in b is <
     10^-6.

_V_a_l_u_e:

    stat: The Wald statistic testing for no shift along the common axis

       p: The P-value of the test. This is calculated assuming that
          stat has a chi-square distribution with (g-1) df, if there
          are g groups

  f.mean: The fitted axis means for each group

_A_u_t_h_o_r(_s):

     Warton, D. David.Warton@unsw.edu.au, translated to R by Ormerod,
     J. 2005-12-08

_R_e_f_e_r_e_n_c_e_s:

     Warton D. I., Wright I. J., Falster D. S. and Westoby M. (2006) A
     review of bivariate line-fitting methods for allometry. 
     _Biological Reviews_ (in press)

_S_e_e _A_l_s_o:

     'line.cis', 'elev.com', 'shift.com'

_E_x_a_m_p_l_e_s:

     #load leaf longevity data
     data(leaflife)

     #Test for common SMA slope amongst species at low rainfall sites
     #with different levels of soil nutrients
     leaf.low.rain=leaflife[leaflife$rain=='low',]
     slope.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)

     #Now test for no shift along the axes of common slope, for sites
     #with different soil nutrient levels but low rainfall:
     shift.com(log10(longev), log10(lma), soilp, data = leaf.low.rain)

     #Now test for no shift along the axes of common slope, for sites
     #with different soil nutrient levels but low rainfall:
     shift.com(log10(longev), log10(lma), soilp, data = leaf.low.rain,
        method='MA')

