find.c              package:smoothSurv              R Documentation

_W_o_r_k _F_u_n_c_t_i_o_n _f_o_r '_s_m_o_o_t_h_S_u_r_v_R_e_g'

_D_e_s_c_r_i_p_t_i_o_n:

     Find mixture proportions that approximate given distribution by a
     G-spline mixture.

_U_s_a_g_e:

     find.c(knots, sdspline, dist = "dnorm")

_A_r_g_u_m_e_n_t_s:

   knots: A vector of G-spline knots mu. 

sdspline: Standard deviation sigma0 of the basis G-spline. 

    dist: A character string specifying the function used to compute a
          density of the distribution you want to approximate. 

_D_e_t_a_i_l_s:

     The function finds the G-spline coefficients that approximates a
     density given by 'dist' in such sense that the value of the
     G-spline is exactly equal to the value of that density in 'knots'.

_V_a_l_u_e:

     Either the vector of G-spline 'c' coefficients or 'NULL' if there
     are problems to find them.

_A_u_t_h_o_r(_s):

     Arno&#353t Kom&#225rek komarek@karlin.mff.cuni.cz

_E_x_a_m_p_l_e_s:

     knots <- seq(-4, 4, 0.5)
     sd0 <- 0.3
     ccoef <- find.c(knots, sd0, dist = "dstlogis")

     ### We plot the approximation together with the truth
     ###
     grid <- seq(-4, 4, 0.05)
     truth <- dstlogis(grid)

     ### Following lines compute the values of the approximation
     grid.big <- matrix(grid, nrow = length(grid), ncol = length(knots))
     knots.big <- matrix(knots, nrow = length(grid), ncol = length(knots), byrow = TRUE)
     normals <- dnorm(grid.big, mean = knots.big, sd = sd0)
     approx <- normals %*% ccoef

     ### Plot it
     plot(grid, approx, type = "l", xlab = "y", ylab = "f(y)", bty = "n")
     lines(grid, truth, lty = 2)
     legend(-4, 0.35, c("approx", "truth"), lty = 1:2, bty = "n")

