give.c              package:smoothSurv              R Documentation

_W_o_r_k _F_u_n_c_t_i_o_n _f_o_r '_s_m_o_o_t_h_S_u_r_v_R_e_g'

_D_e_s_c_r_i_p_t_i_o_n:

     Give a vector of all 'c' G-spline coefficients  satisfying the
     three constrains (see below) if only (g-3) c's are given.

_U_s_a_g_e:

     give.c(knots, sdspline, last.three, c.rest)

_A_r_g_u_m_e_n_t_s:

   knots: A vector of G-spline knots mu. 

sdspline: Standard deviation sigma0 of the basis G-spline. 

last.three: Indeces of the three 'c' G-spline coefficients which are 
          not included in 'c.rest'. This must be a vector of length 3
          with three different numbers from '1:length(knots)'. 

  c.rest: A vector of '\length(knots) - 3' 'c' spline coefficients
          corresponding to knots 'knots[-last.three]'.  They must all
          lie between zero and one and their sum must be lower  or
          equal to one. 

_D_e_t_a_i_l_s:

     The functions computes remaining three 'c' G-spline coefficients
     (if it is possible) such that the resulting G-spline satisfies the
     following:

                         c[1] + ... c[g] = 1,


                    c[1]mu[1] + ... c[g]mu[g] = 0,


            c[1]mu[1]^2 + ... c[g]mu[g]^2 = 1 - sigma0^2.

_V_a_l_u_e:

     A vector of all 'length(knots)' 'c' G-spline coefficients.

_N_o_t_e:

     WARNING: This function is primarily used inside 'smoothSurvReg'.
     Consequently, it has very few error checks on its input arguments.

_A_u_t_h_o_r(_s):

     Arno&#353t Kom&#225rek komarek@karlin.mff.cuni.cz

_E_x_a_m_p_l_e_s:

     knots <- seq(-4, 4, 0.5)
     sd0 <- 0.3
     ccoef <- find.c(knots, sd0, dist = "dstlogis")

     last.three <- c(3, 7, 10)
     c.rest <- ccoef[-last.three]
     ccoef2 <- give.c(knots, sd0, last.three, c.rest)

     print(ccoef)
     print(ccoef2)    ## Almost no change

