### Name: spatialkernel-package
### Title: The Spatialkernel Package
### Aliases: spatialkernel-package
### Keywords: package

### ** Examples

## An example of spatial segregation analysis
## Not run: 
##D ## source in Lansing Woods tree data within a polygon boundary
##D data(lansing)
##D data(polyb)
##D ## select data points within polygon
##D ndx <- which(pinpoly(polyb, as.matrix(lansing[c("x", "y")])) > 0)
##D pts <- as.matrix(lansing[c("x", "y")])[ndx,]
##D marks <- lansing[["marks"]][ndx]
##D ## select bandwidth
##D h <- seq(0.02, 0.1, length=101)
##D cv <- cvloglk(pts, marks, h=h)$cv
##D hcv <- h[which.max(cv)]
##D plot(h, cv, type="l")
##D ## estimate type-specific probabilities and do segregation tests
##D ## by one integrated function
##D sp <- spseg(pts, marks, hcv, opt=3, ntest=1000, poly=polyb)
##D ## plot estimated type-specific probability surfaces
##D plotphat(sp)
##D ## additional with pointwise significance contour lines
##D plotmc(sp, quan=c(0.025, 0.975))
##D ## p-value of the Monte Carlo segregation test
##D cat("\np-value of the Monte Carlo segregation test", sp$pvalue)
##D 
##D ##estimate intensity function at grid point for presentation
##D ##with bandwidth hcv
##D gridxy <- as.matrix(expand.grid(x=seq(0, 1, length=101), y=seq(0, 1, length=101)))
##D ndx <- which(pinpoly(polyb, gridxy) > 0) ##inside point index
##D lam <- matrix(NA, ncol=101, nrow=101)
##D lam[ndx] <- lambdahat(pts, hcv, gpts = gridxy[ndx,], poly =
##D     polyb)$lambda
##D brks <- pretty(range(lam, na.rm=TRUE), n=12)
##D plot(0, 0, xlim=0:1, ylim=0:1, xlab="x", ylab="y", type="n")
##D image(x=seq(0, 1, length=101), y=seq(0, 1, length=101),
##D     z=lam, add=TRUE, breaks=brks, col=risk.colors(length(brks)-1))
##D polygon(polyb)
##D metre(0, 0.01, 0.05, 0.51, lab=brks, col=risk.colors(length(brks)-1), cex=1)
##D 
##D ## An example of inhomogeneous intensity function and K function
##D ## estimated with the same data
##D s <- seq(0, 0.06, length=101)
##D lam <- lambdahat(pts, hcv, poly=polyb)$lambda
##D kin <- kinhat(pts, lam, polyb, s)
##D plot(kin$s, kin$k-pi*(kin$s)^2, xlab="s", ylab="k-pi*s^2", type="l")
## End(Not run)



