### Name: stashR
### Title: Classes "remoteDB" and "localDB"
### Aliases: remoteDB remoteDB-class localDB-class dbUnlink,localDB-method
###   dbUnlink dbInsert,localDB,character-method
###   dbFetch,localDB,character-method dbDelete,localDB,character-method
###   dbList,localDB-method dbExists,localDB,character-method
###   dbDelete,remoteDB,character-method dbExists,remoteDB,character-method
###   dbFetch,remoteDB,character-method dbInsert,remoteDB,character-method
###   dbList,remoteDB-method dbList dbSync,remoteDB-method dbSync
###   dbCreate,remoteDB-method dbCreate,localDB-method dbCreate
### Keywords: classes

### ** Examples

## Not run: 
##D ## Objects of the class localDB
##D 
##D wd <- getwd()
##D dir <- file.path(wd,"localDBExample")
##D 
##D ## Create local stashR data repository 'localDBExample'
##D fhLocal <- new("localDB", dir = dir, name = "localDBExample")
##D 
##D ## Insert key-value data into 'localDBExample' 
##D v <- 1:10
##D dbInsert(fhLocal,key = "vector", value = v)
##D m <- matrix(1:20,5,4)
##D dbInsert(fhLocal,key = "matrix", value = m)
##D d <- data.frame(cbind(id = 1:5, age=c(12,11,15,11,14), sex = c(1,1,0,1,0)))
##D dbInsert(fhLocal,key = "dataframe", value = d)
##D l <- list(v = v, m = m, df = d)
##D dbInsert(fhLocal, key = "list", value = l)
##D 
##D dbList(fhLocal)
##D 
##D dbFetch(fhLocal, "dataframe") 
##D dbDelete(fhLocal, "vector")
##D dbExists(fhLocal, "vector")
##D dbList(fhLocal) 
##D 
##D ## Objects of the class remoteDB
##D 
##D ## The same key-value data used in the previous example for localDB
##D ## has been stored in a remoteDB repository on the internet at:
##D myurl <- "http://www.biostat.jhsph.edu/~seckel/remoteDBExample"
##D 
##D wd <- getwd()
##D dir <- file.path(wd,"remoteDBExample") 
##D ## Create local copy of data repository 'remoteDBExample'
##D fhRemote <- new("remoteDB", url= myurl, 
##D             dir = dir, name= "remoteDBExample")
##D 
##D dbList(fhRemote)
##D dbExists(fhRemote,c("vector", "array","list", "function"))
##D ## downloads 'vector' data from the remoteDB repository
##D dbFetch(fhRemote, "vector") 
##D ## fetches without downloading again 
##D dbFetch(fhRemote, "vector") 
##D ## synchronize all local copies of the data to the remote version
##D dbSync(fhRemote, key = NULL)
## End(Not run)



