cif2.ks             package:surv2sample             R Documentation

_K_o_l_m_o_g_o_r_o_v-_S_m_i_r_n_o_v _T_w_o-_S_a_m_p_l_e _T_e_s_t _f_o_r _C_u_m_u_l_a_t_i_v_e _I_n_c_i_d_e_n_c_e _F_u_n_c_t_i_o_n_s

_D_e_s_c_r_i_p_t_i_o_n:

     Compares cumulative incidence functions (CIF) for one failure
     cause in two samples of censored competing risks data using the
     Kolmogorov-Smirnov-type test.

_U_s_a_g_e:

     cif2.ks(x, group, cause = 1, nsim = 2000, nsim.plot = 50)

_A_r_g_u_m_e_n_t_s:

       x: a '"Survcomp"' object, as returned by the 'Survcomp'
          function.

   group: a vector indicating to which group each observation belongs.
          May contain values 1 and 2 only.

   cause: For which cause of failure should the CIFs be compared?

    nsim: the number of simulations to approximate the p-value. Must be
          positive.

nsim.plot: the number of simulated paths of the test process to be
          returned (for possible plotting). Must be at most 'nsim'.

_D_e_t_a_i_l_s:

     The test compares cumulative incidence functions F_1(t,k),
     F_2(t,k) for a particular failure cause k.

     The test statistic is the maximum absolute difference of the two
     cumulative incidence functions. Its asymptotic distribution is
     complicated, therefore the martingale-based simulation
     approximation is employed. See Lin (1997).

_V_a_l_u_e:

     A list with class attributes '"cif2.int"' and '"lwy.test"', with
     components: 

    stat: the test statistic.

pval.sim: the simulation based p-value.

test.process: the test process (difference of the two CIFs).

test.process.sim: simulated paths of the test process (a matrix with
          'nsim.plot' columns).

    time: sorted times.

     Further components are 'cause', 'nsim', 'nsim.plot', the same as
     on input.

_A_u_t_h_o_r(_s):

     David Kraus (<URL: http://www.davidkraus.net/>)

_R_e_f_e_r_e_n_c_e_s:

     Lin, D. Y. (1997) Non-parametric inference for cumulative
     incidence functions in competing risks studies. _Stat. Med._ *16*,
     901-910.

_S_e_e _A_l_s_o:

     See the 'plot' method inherited from the class '"lwy.test"'.

     See 'cif' and 'plot.cif' for estimation and plotting of CIFs,
     'cif2.int', 'cif2.logrank' and 'cif2.neyman' for other two-sample
     tests.

_E_x_a_m_p_l_e_s:

     ## bone marrow transplant data
     data(bmt1)

     ## compare CIFs for cause 1 (relapse)
     ## print results
     print(a <- cif2.ks(Survcomp(bmt1$time, bmt1$event), bmt1$donor,
           cause = 1))
     ## plot the test process and simulated paths
     plot(a)

     ## compare CIFs for cause 2 (death in remission)
     ## print results
     print(a <- cif2.ks(Survcomp(bmt1$time, bmt1$event), bmt1$donor,
         cause = 2))
     ## plot the test process and simulated paths
     plot(a)

