proprate2.gs           package:surv2sample           R Documentation

_G_i_l_l-_S_c_h_u_m_a_c_h_e_r _T_e_s_t _o_f _P_r_o_p_o_r_t_i_o_n_a_l _R_a_t_e_s _i_n _T_w_o _S_a_m_p_l_e_s _o_f _C_e_n_s_o_r_e_d _D_a_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Checks the assumption of proportional rates (proportional hazards,
     proportional odds) in two samples of right-censored data using the
     Gill-Schumacher test based on the comparison of two estimates of
     the rate ratio.

_U_s_a_g_e:

     proprate2.gs(x, group, model = 0, weight1 = "logrank",
                  weight2 = "prentice")

_A_r_g_u_m_e_n_t_s:

       x: a '"Surv"' object, as returned by the 'Surv' function.

   group: a vector indicating to which group each observation belongs.
          May contain values 1 and 2 only.

   model: the type of model. Possible values are 0 for proportional
          hazards, 1 for proportional odds.

weight1, weight2: weight functions for the ratio estimates. Possible
          values are '"logrank"', '"prentice"', '"gehan"'.

_D_e_t_a_i_l_s:

     This function performs the Gill-Schumacher test of the hypothesis
     that transformation rates (currently hazard rates or odds
     functions) are proportional (their ratio is constant in time) in
     two samples of censored survival data.

     The test was proposed by Gill and Schumacher (1987) for
     proportional hazards, see Kraus (2007) for its extension to
     proportional transformation rates. The test statistic compares two
     weighted estimates of the ratio of rates. Possible weights are of
     the logrank, Prentice-Wilcoxon or Gehan type.

_V_a_l_u_e:

     A '"proprate2.gs"' object with components: 

    stat: the test statistic.

    pval: the p-value.

eta1, eta2: weighted estimates of the rate ratio.

     Some of input parameters are included too.

_A_u_t_h_o_r(_s):

     David Kraus (<URL: http://www.davidkraus.net/>)

_R_e_f_e_r_e_n_c_e_s:

     Gill, R. and Schumacher, M. (1987) A simple test of the
     proportional hazards assumption. _Biometrika_ *74*, 289-300.

     Kraus, D. (2007) Checking proportional rates in the two-sample
     transformation model. Research Report 2203, Institute of
     Information Theory and Automation, Prague. Available at <URL:
     http://www.davidkraus.net/surv2sample/>.

_S_e_e _A_l_s_o:

     'proprate2.neyman', 'proprate2.ks' for other tests of the
     proportional rate assumption

     'proprate2' for the simplified partial likelihood estimation

_E_x_a_m_p_l_e_s:

     ## chronic active hepatitis data
     data(hepatitis)

     ## perform the Gill--Schumacher test of proportional odds
     proprate2.gs(Surv(hepatitis$time, hepatitis$status),
         hepatitis$treatment, model = 1)

