proprate2.ks           package:surv2sample           R Documentation

_K_o_l_m_o_g_o_r_o_v-_S_m_i_r_n_o_v _T_e_s_t _o_f _P_r_o_p_o_r_t_i_o_n_a_l _R_a_t_e_s _i_n _T_w_o _S_a_m_p_l_e_s _o_f _C_e_n_s_o_r_e_d _D_a_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Checks the assumption of proportional rates (proportional hazards,
     proportional odds) in two samples of right-censored data using the
     Kolmogorov-Smirnov test based on the simplified partial likelihood
     score process.

_U_s_a_g_e:

     proprate2.ks(x, group, model = 0, nsim = 2000, nsim.plot = 50,
                  beta.init = 0, maxiter = 20, eps = 1e-09)

_A_r_g_u_m_e_n_t_s:

       x: a '"Surv"' object, as returned by the 'Surv' function.

   group: a vector indicating to which group each observation belongs.
          May contain values 1 and 2 only.

   model: the type of model. Possible values are 0 for proportional
          hazards, 1 for proportional odds.

    nsim: the number of simulations to approximate the p-value. Must be
          positive.

nsim.plot: the number of simulated paths of the test process to be
          returned (for possible plotting). Must be at most 'nsim'.

beta.init: the initial parameter value for iteration in the simplified
          partial likelihood estimation.

 maxiter: the maximum number of iterations.

     eps: the convergence tolerance parameter. The convergence
          criterion is |(l-l_old)/l|<'eps'.

_D_e_t_a_i_l_s:

     This function tests the hypothesis that transformation rates
     (currently hazard rates or odds functions) are proportional (their
     ratio is constant in time) in two samples of censored survival
     data.

     The proportional rate model is estimated by a two-sample
     simplification of the partial likelihood. The test then uses the
     Kolmogorov-Smirnov supremum statistic based on the simplified
     partial likelihood score process. The p-value is computed using
     the martingale simulation technique.

_V_a_l_u_e:

     A list of class '"proprate2.ks"' and '"lwy.test"', with main
     components: 

    stat: the test statistic.

pval.sim: the simulation based p-value.

test.process: the test process.

test.process.sim: simulated paths of the test process (a matrix with
          'nsim.plot' columns).

    time: sorted times.

     Some of input parameters and further components are included too.

_A_u_t_h_o_r(_s):

     David Kraus (<URL: http://www.davidkraus.net/>)

_R_e_f_e_r_e_n_c_e_s:

     Bagdonavicius, V. and Nikulin, M. (2000) On goodness-of-fit for
     the linear transformation and frailty models. _Statist. Probab.
     Lett._ *47*, 177-188.

_S_e_e _A_l_s_o:

     'plot' method inherited from the class '"lwy.test"'

     'proprate2.neyman', 'proprate2.gs' for other tests of the
     proportional rate assumption

     'proprate2' for estimation

_E_x_a_m_p_l_e_s:

     ## chronic active hepatitis data
     data(hepatitis)

     ## perform the Komogorov--Smirnov test of proportional odds
     a = proprate2.ks(Surv(hepatitis$time, hepatitis$status),
         hepatitis$treatment, model = 1)
     a
     ## plot the test process and simulated paths
     plot(a)

