surv2.ks             package:surv2sample             R Documentation

_T_w_o-_S_a_m_p_l_e _K_o_l_m_o_g_o_r_o_v-_S_m_i_r_n_o_v, _C_r_a_m_e_r-_v_o_n _M_i_s_e_s _a_n_d
_A_n_d_e_r_s_o_n-_D_a_r_l_i_n_g _T_e_s_t _f_o_r _C_e_n_s_o_r_e_d _D_a_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Performs the Kolmogorov-Smirnov, Cramer-von Mises and
     Anderson-Darling test to compare the distribution of survival
     times in two samples of censored data.

_U_s_a_g_e:

     surv2.ks(x, group, process = "w", approx = "lwy", nsim = 2000,
              nsim.plot = 50)

_A_r_g_u_m_e_n_t_s:

       x: a '"Surv"' object, as returned by the 'Surv' function.

   group: a vector indicating to which group each observation belongs.
          May contain values 1 and 2 only.

 process: the type of the test process. Possible values are '"w"' for
          the difference of Nelson-Aalen estimates (asymptotically a
          Brownian motion, i.e., *W*iener process), '"b"' for a
          transformation of this process (asymptotically a Brownian
          *b*ridge).

  approx: the method of approximating the distribution of test
          statistics. Possible values are '"lwy"' or '"mart"' for the
          martingale-based simulation, '"perm"' for permutations,
          '"boot"' for the bootstrap.

    nsim: the number of simulations (martingale simulations,
          permutations or bootstrap samples).

nsim.plot: the number of simulated paths of the test process to be
          returned (for possible plotting). Must be at most 'nsim'.

_D_e_t_a_i_l_s:

     The function implements tests based on functionals of the logrank
     process U(t) (which is the process of logrank statistics computed
     from observations in (0,t), see Section 7.5 of Fleming and
     Harrington (1991)). This process (properly normalised) is
     asymptotically a Brownian motion in transformed time. If 'process'
     is '"w"', the supremum (KS) and integral (CM, AD) test statistics
     are computed from this process. If 'process' is '"b"', the tests
     are instead based on the process U(t)(1+v(t)/v(tau))^(-1), which
     is asymptotically a Brownian bridge in transformed time.

_V_a_l_u_e:

     A list with class attributes '"surv2.int"' and '"lwy.test"', with
     main components: 

 stat.ks: the Kolmogorov-Smirnov statistic.

 pval.ks: the corresponding p-value.

pval.ks.asympt: the asymptotic p-value.

 stat.cm: the Cramer-von Mises statistic.

 pval.cm: the corresponding p-value.

 stat.ad: the Anderson-Darling statistic.

 pval.ad: the corresponding p-value.

    time: sorted times.

test.process: the test process.

test.process.sim: simulated paths of the test process (a matrix with
          'nsim.plot' columns).

     Some of input arguments are also contained in the output.

_A_u_t_h_o_r(_s):

     David Kraus (<URL: http://www.davidkraus.net/>)

_R_e_f_e_r_e_n_c_e_s:

     Andersen, P. K., Borgan, O., Gill, R. D. and Keiding, N. (1993)
     _Statistical Models Based on Counting Processes._ Springer, New
     York. 

     Fleming, T. R. and Harrington, D. P. (1991) _Counting Processes
     and Survival Analysis._ Wiley, New York.

_S_e_e _A_l_s_o:

     See the 'plot' method inherited from the class '"lwy.test"'.

     See also 'surv2.neyman', 'surv2.logrank', 'survdiff', 'survfit.'

_E_x_a_m_p_l_e_s:

     ## gastric cancer data
     data(gastric)

     ## print results
     print(a <- surv2.ks(Surv(gastric$time, gastric$event),
         gastric$treatment))
     ## plot the test process and simulated paths
     plot(a)

