### Name: cif
### Title: Estimates of Cumulative Incidence Functions for Competing Risks
###   Data
### Aliases: cif
### Keywords: survival

### ** Examples

## bone marrow transplant data
data(bmt1)

print(a <- cif(Survcomp(bmt1$time, bmt1$event), bmt1$donor))
str(a)

## several first times and cifs for group 1 (HLA-identical
## sibling donors)
head(cbind(a[[1]]$time, a[[1]]$f))
## several last times and cifs for group 2 (HLA-matched
## unrelated donors)
tail(cbind(a[[2]]$time, a[[2]]$f))

## plot aggregate cumulative incidence functions for each
## donor type to see probabilities within groups
plot(a)



