### Name: cif2.neyman
### Title: Two-Sample Neyman's Smooth Test for Cumulative Incidence
###   Functions
### Aliases: cif2.neyman summary.cif2.neyman
### Keywords: survival

### ** Examples

## bone marrow transplant data
data(bmt1)

## compare CIFs for cause 1 (relapse)
## test with fixed dimension
cif2.neyman(Survcomp(bmt1$time, bmt1$event), bmt1$donor, cause = 1,
    data.driven = FALSE)
## data-driven test
print(a <- cif2.neyman(Survcomp(bmt1$time, bmt1$event), bmt1$donor,
    cause = 1, data.driven = TRUE))
## print details on the selection procedure
summary(a)

## compare CIFs for cause 2 (death in remission)
cif2.neyman(Survcomp(bmt1$time, bmt1$event), bmt1$donor, cause = 2)



