### Name: plot.cif
### Title: Plots of Cumulative Incidence Functions for Competing Risks Data
### Aliases: plot.cif
### Keywords: survival

### ** Examples

## bone marrow transplant data
data(bmt1)

## plot aggregate cumulative incidence functions for each
## donor type, i.e., plotting by groups, to see the probability
## structure within groups
plot(cif(Survcomp(bmt1$time, bmt1$event), bmt1$donor))

## plot CIFs by causes, to compare donor type effects on each
## cause of failure
plot(cif(Survcomp(bmt1$time, bmt1$event), bmt1$donor), by = "cause")



