### Name: plot.proprate2.fit
### Title: Plot the Two-Sample Proportionl Rate Model for Censored Data
### Aliases: plot.proprate2.fit
### Keywords: survival

### ** Examples

## chronic active hepatitis data
data(hepatitis)

## fit the proportional odds model
fit = with(hepatitis, proprate2(Surv(time, status), treatment,
    model = 1))

## plot model-based and model-free estimates of odds functions
plot(fit)
## their logarithms
plot(fit, log.transform = TRUE)
## differences of log-functions
plot(fit, diff = TRUE)



