### Name: surv2.logrank
### Title: Two-Sample Weighted Logrank Tests and Their Combinations
### Aliases: surv2.logrank
### Keywords: survival

### ** Examples

## gastric cancer data
data(gastric)

## Prentice--Wilcoxon (G^1) test
surv2.logrank(Surv(gastric$time, gastric$event),
    gastric$treatment, rho.gamma = c(1,0))

## combination of G(0,0), G(1,0), G(1,1) statistics
## maximum test
print(a <- surv2.logrank(Surv(gastric$time, gastric$event),
    gastric$treatment, rho.gamma = list(c(0,0), c(1,0), c(1,1)),
    comb = "max"))
## print individual statistics
a$stats



