### Name: surv2.neyman
### Title: Two-Sample Neyman's Smooth Test for Censored Data
### Aliases: surv2.neyman summary.surv2.neyman
### Keywords: survival

### ** Examples

## gastric cancer data
data(gastric)

## test with fixed dimension
surv2.neyman(Surv(gastric$time, gastric$event), gastric$treatment,
    data.driven = FALSE)

## data-driven test with nested subsets
## without minimum dimension (i.e., minimum dimension 1)
summary(surv2.neyman(Surv(gastric$time, gastric$event),
    gastric$treatment, data.driven = TRUE, subsets = "nested"))
## with minimum dimension 3
summary(surv2.neyman(Surv(gastric$time, gastric$event),
    gastric$treatment, data.driven = TRUE, subsets = "nested",
    d0 = 3))

## data-driven test with all subsets
## without high-priority functions
summary(surv2.neyman(Surv(gastric$time, gastric$event),
    gastric$treatment, data.driven = TRUE, subsets = "all"))
## with 2 high-priority functions
summary(surv2.neyman(Surv(gastric$time, gastric$event),
    gastric$treatment, data.driven = TRUE, subsets = "all",
    d0 = 2))



