### Name: tclVarFun
### Title: Manipulate R variables and functions from tcl and back
### Aliases: makeTclNames tclFun tclGetValue tclSetValue tclVarExists
###   tclVarFind tclVarname
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ## Tcl functions and variables manipulation
##D     tclVarExists("tcl_version")
##D     tclVarExists("probably_non_existant")
##D     tclVarFind("tcl*")
##D 
##D     # Using tclVarname() and tclGetValue()... intented for better match between R and Tcl variables
##D     Test <- tclVarname("Test", "this is a test!")
##D     # Now 'Test' exist both in R and in Tcl... In R, you need to use tclvalue(Test) to retrieve its content
##D     # If a variable already exists in Tcl, its content is preserved using keep.existing = TRUE
##D     .Tcl("set A_Variable {just to test...}") # Create a variable in Tcl and assign "just a test..." to it
##D     A_Variable <- tclVarname("A_Variable", "something else?") # Create the dual variable with same name
##D     tclvalue(A_Variable) # Content of the variable is not changed!
##D 
##D     # If you want to retrieve the content of a Tcl variable, but do not want to create a reference to it in R, use:
##D     .Tcl("set Another_Variable {something in it}")  # Create a Tcl variable, not visible from R
##D     tclGetValue("Another_Variable") # Get its content in R
##D   
## End(Not run)



