### Name: tk2dde
### Title: Use DDE (Dynamic Data Exchange) under Windows
### Aliases: tk2dde tk2dde.exec tk2dde.poke tk2dde.request tk2dde.services
###   .tk2dde.require
### Keywords: utilities IO

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ## Examples of DDE - Windows only
##D     ###### Examples using wish
##D     # Start a Wish84 console side-by-side with R.
##D     # (to get wish, you need to install ActiveTcl from
##D     # http://www.activestate.com/Products/ActiveTcl/)
##D     # Once it is done, start 'Wish84' from the start menu)
##D     # Register the Wish console as a DDE server, that is, type in it:
##D     # % package require dde
##D     # % dde servername wish
##D 
##D     # In R:
##D     tk2dde("R") # Return 0 if succeed
##D     tk2dde.services()
##D     # Evaluate some string in wish
##D     tk2dde.exec("TclEval", "wish", "{puts {Hello World!}}")
##D     # Give a value to a variable in wish
##D     tk2dde.poke("TclEval", "wish", "myvar", "This is a string!")
##D     tk2dde.poke("TclEval", "wish", "mynumvar", 34.56)
##D 
##D     # In wish, check that vars exist and have correct value
##D     # % puts $myvar
##D     # % puts $mynumvar
##D 
##D     # Get the value of one variable from wish into R
##D     tk2dde.request("TclEval", "wish", "myvar")
##D     tk2dde.request("TclEval", "wish", "mynumvar")
##D     # Note that you don't know here if it is a string, a numerical data, or so...
##D     # You have to know and convert yourself!
##D 
##D     # Now, the other way: execute a R function from wish
##D     # You first need to register a R function for callback
##D     # (I don't how yet to deal with arguments here, so, use functions without args!)
##D     doDDE <- function() cat("DDE execute!\n")  # A simple function without arguments
##D     tclFun(doDDE)
##D     # And in wish
##D     # % dde execute TclEval R doDDE
##D 
##D     # Once you have defined a variable using tclVar, you can get or change its value
##D     #from the dde server
##D     # However, tclVar gives cryptic names like ::RTcl1. so we prefer to use tclVarname
##D     myvar <- tclVarname("myvar", "this is a test...")
##D     tclvalue(myvar) # This is the way we access to this variable in R
##D 
##D     # In wish you get the value and change it:
##D     # % dde request TclEval R myvar
##D     # Again, dde poke does not work here and must be replaced by an execute command
##D     # This doesn't work (???)
##D     # % dde poke TclEval R myvar {yes! and it works...}
##D     # ... but this is fine
##D     # % dde execute TclEval R {set myvar {yes! and it works...}}
##D 
##D     # And in R...
##D     tclvalue(myvar)
##D 
##D     # You can also change the value of a variable, or run a command in R from
##D     #the command line using execdde.exe:
##D     # Copy %R_Home%\library\tcltk2\libs\execdde.exe somewhere in your path,
##D     # start a DOS window
##D     # and enter the following commands:
##D     # > execdde -s TclEval -t R -c doDDE > NUL
##D     # > if errorlevel 1 echo An error occurred... branch accordingly in your batch file!
##D     # > execdde -s TclEval -t R -c "set myvar {ok from execdde!}" > NUL
##D 
##D     # And in R:
##D     tclvalue(myvar)
##D     # Note that, thanks to separate event loops, this work also when R is calculating...
##D 
##D     # Other examples of DDE use:
##D     #### Manipulating Microsoft Excel ####
##D     # Start Excel with a blank workbook, then...
##D 
##D     # Change values in Excel from R:
##D     tk2dde.poke("Excel", "Sheet1", "R1C1:R2C1", "{5.7\n6.34}")   # Some data
##D     tk2dde.poke("Excel", "Sheet1", "R3C1", "{= A1 + A2}")        #... and a formula
##D 
##D     # Read values in Excel (note that results of formulas are returned)
##D     Res <- tk2dde.request("Excel", "Sheet1", "R1C1:R3C1")
##D     Res
##D     as.numeric(strsplit(Res, "\r\n", fixed = TRUE)[[1]])        # Convertion
##D 
##D     # Execute a command in Excel
##D     tk2dde.exec("Excel", "Sheet1", "{\[\Select(\"R1C1:R3C1\")]\[New(2,2)\]}")
##D     # New(2,2) create a bar graph in a separate sheet
##D     # Note: close this graph now, in order to run the remaining commands properly!
##D 
##D     # R as server and Excel as client
##D     # Prepare R as server
##D     tk2dde("SciViewsR") # Now, my server name is TclEval|SciViewsR !
##D     # Create a variable that will be shared with Excel
##D     XlVar <- tclVarname("XlVar", "this is a test!")
##D     # Enter a formula somewhere in Excel to link to this variable
##D     tk2dde.poke("Excel", "Sheet1", "R5C1", "=TclEval|SciViewsR!'::XlVar'")
##D 
##D     # Now, change the content in XlVar
##D     tclvalue(XlVar) <- "Another text..."
##D     # Rem: in my Excel, the content of the cell is not changed automatically...
##D     # I must reenter the formula for the changes to be considered!?
##D 
##D     #### Manipulating Microsoft Word ####
##D     # Start Word and then...
##D     tk2dde.exec("Winword", "System", "{\[EndOfDocument\]}")
##D     tk2dde.exec("Winword", "System", "{\[Insert \"Text from Tcl.\"\]}", async = TRUE)
##D 
##D     # Can also use:
##D     #  AppMaximize 1
##D     #  StatOfDocument
##D     #  EditFind .Find="hello" .PatternMatch=1
##D     #  FileExit 2
##D     #  FileClose 2 # 2 = close without saving, 1 = save first, 0 = prompt
##D 
##D     # If you need to start the application (Word) before using DDE, you must
##D     # wait that Word becomes ready!
##D     # This is a Tcl proc that shows how to do that
##D     #### TO DO: translate this in R...
##D     # proc doc2txt fn {
##D     #     package require dde
##D     #     package require Tk; # because we need [selection]
##D     #     eval exec [auto_execok start] [list $fn] &
##D     #
##D     #     #Loop to wait until Word is really there, and ready to talk
##D     #     set word ""
##D     #     while {$word==""} {
##D     #   set word [dde services Winword System]
##D     #   after 200
##D     #     }
##D     #     after 1000 ;# wait for the window to load...
##D     #     dde execute Winword System {[EditSelectAll]}
##D     #     dde execute Winword System {[EditCopy]}
##D     #     set res [selection get -selection CLIPBOARD]
##D     #     dde execute Winword System {[FileExit 2]}
##D     #     set res
##D     # }
##D     # doc2txt {C:\Temp\Test.doc}
##D 
##D     #### Control Matlab (don't work with Rel 12?!)
##D     # Start Matlab and then...
##D     tk2dde.exec("Matlab", "Engine", "{s = ones(5);}")
##D     # Then in Matlab, type s
##D 
##D     #### Manipulating Progman to create and delete shortcuts ####
##D     tk2dde.exec("progman", "progman", "{\[CreateGroup(Bogus)\]}")
##D     tk2dde.exec("progman", "progman", "{\[AddItem(notepad.exe,BogusPadLink)\]}")
##D     tk2dde.exec("progman", "progman", "{\[ShowGroup(Bogus,0)\]}")
##D     tk2dde.exec("progman", "progman", "{\[ShowGroup(Bogus,1)\]}")
##D     # And delete it...
##D     tk2dde.exec("progman", "progman", "{\[DeleteItem(BogusPadLink)\]}")
##D     tk2dde.exec("progman", "progman", "{\[DeleteGroup(Bogus)\]}")
##D     ## Rem: the same can be done with tcom, if installed:
##D     #.Tcl("package require tcom")
##D     #.Tcl("set sh [::tcom::ref createobject {WScript.Shell}]")
##D     #.Tcl("set lnk [$sh CreateShortcut {c:\\temp\\boguspad.lnk}]")
##D     #.Tcl("$lnk TargetPath {\"notepad.exe\"}")
##D     #.Tcl("$lnk WorkingDirectory {c:\\temp}")
##D     #.Tcl("$lnk Arguments Tutorial.txt")
##D     #.Tcl("$lnk Save")
##D 
##D     ## Controlling Internet Explorer through DDE
##D     # Start Internet Explorer, then...
##D     tk2dde.exec("iexplore", "WWW_OpenURL", "{http://www.sciviews.org/}")
##D     # It works, but return an error in R???
##D     tk2dde.exec("iexplore", "WWW_ShowFile", "{C:/progra~1/R/rw2001/doc/html/index.html}")
##D     # Idem
##D     # Info on the current opened window
##D     tk2dde.request("iexplore", "WWW_GetWindowInfo", "1")
##D     # and this does not work!)
##D     # tk2dde.request("iexplore", "WWW_ListWindows", "0")
##D 
##D     ## Controlling Windows explorer
##D     tk2dde.exec("Folders", "AppProperties", "{\[ViewFolder(\"C:\Temp\",\"C:\Temp\",5)\]}")
##D     #... or you can also try 'ExplodeFolder'
##D     
##D     # Search in folder
##D     tk2dde.exec("Folders", "AppProperties", "{\[FindFolder(\"\",\"C:\Temp\")\]}")
##D   
## End(Not run)



