### Name: tk2ico
### Title: Manipulate icons under Windows
### Aliases: tk2ico tk2ico.create tk2ico.destroy tk2ico.hicon tk2ico.info
###   tk2ico.load tk2ico.pos tk2ico.set tk2ico.taskbar.add
###   tk2ico.taskbar.delete tk2ico.taskbar.modify tk2ico.text
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ## Examples of tk2ico - icon manipulation under Windows
##D     tt2 <- tktoplevel()
##D     # Load a system icon (there are: "application", "asterisk", "error",
##D     # "exclamation", "hand", "question", "information", "warning", and "winlogo".
##D     Warn <- tk2ico.load(res = "warning")
##D     tk2ico.info(Warn)
##D     # Change the text
##D     tk2ico.text(Warn)
##D     tk2ico.text(Warn, "Warning icon")
##D     tk2ico.text(Warn)
##D     # Get hicon
##D     tk2ico.hicon(Warn)
##D     # Change the icon of my window tt2
##D     tk2ico.set(tt2, Warn)
##D     # Do not forget to destroy icon to free resource when not needed any more
##D     tk2ico.destroy(Warn)
##D     rm(Warn)
##D     # Load an icon from the resource section of an exe, or dll
##D     Rico <- tk2ico.load(file.path(Sys.getenv("R_HOME"), "bin", "R.exe"), res = "R")
##D     tk2ico.info(Rico)
##D     tk2ico.set(tt2, Rico)
##D     tk2ico.destroy(Rico)
##D     rm(Rico)
##D 
##D     # Load one or several icons from an .ico file
##D     libdir <- file.path(.path.package(package="tcltk2")[1], "etc")
##D     SVico <- tk2ico.create(file.path(libdir, "SciViews.ico"))
##D     # The various resolution icons created from this file
##D     tk2ico.info(SVico)
##D     # Change the default position to 1
##D     tk2ico.pos(SVico, 1)
##D     # Change only the small icon (use Alt-Tab to see the large one)
##D     tk2ico.set(tt2, SVico, pos = 0, type = "small")
##D 
##D     ### This does not work!
##D     ## Set a taskbar icon (rem: should use callback usually)
##D     #tk2ico.taskbar.add(SVico, pos = 0, text = "{my tcltk taskbar icon}")
##D     ## Change its text...
##D     #tk2ico.tackbar.modify(SVico, text = "{text changed!}")
##D     ##... and delete it
##D     #tk2ico.taskbar.delete(SVico)
##D 
##D     # Destroy the icons
##D     tk2ico.destroy(SVico)
##D     rm(SVico)
##D 
##D     # When done, dispose of the window
##D     tkdestroy(tt2)
##D   
## End(Not run)



