### Name: tk2reg
### Title: Manipulate the registry under Windows
### Aliases: tk2reg tk2reg.broadcast tk2reg.delete tk2reg.deletekey
###   tk2reg.get tk2reg.keys tk2reg.set tk2reg.setkey tk2reg.type
###   tk2reg.values
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ## Examples of tk2reg - registry manipulation under Windows
##D     # Rem: HKEY_LOCAL_MACHINE, HKEY_USERS, HKEY_CLASSES_ROOT, HKEY_CURRENT_USER,
##D     #      HKEY_CURRENT_CONFIG, HKEY_PERFORMANCE_DATA, HKEY_DYN_DATA
##D     Rkey <- "HKEY_LOCAL_MACHINE\\Software\\R-core\\R"   # The R key
##D     Rsubkey <- paste(Rkey, "subkey", sep = "\\")        # A subkey
##D 
##D     # Get all subkeys for Software in the local machine
##D     tk2reg.keys("HKEY_LOCAL_MACHINE\\Software")
##D 
##D     # Get all names in the R key
##D     tk2reg.values(Rkey)
##D     # Get info about registered R
##D     tk2reg.get(Rkey, "Current Version")
##D     tk2reg.get(Rkey, "InstallPath")
##D 
##D     # Create a subkey (explore the registry with regedit.exe to see it)
##D     tk2reg.setkey(Rsubkey)
##D     # Add something in it
##D     tk2reg.set(Rsubkey, "test", "a key added with tcltk2 registry!", type = "sz")
##D 
##D     # Get the type of a value
##D     tk2reg.type(Rsubkey, "test")
##D     # Get a value in a key
##D     tk2reg.get(Rsubkey, "test")
##D 
##D     # Delete a name in a key (take care: dangerous!)
##D     tk2reg.delete(Rsubkey, "test")
##D     # Delete a whole key (take care: very dangerous!)
##D     tk2reg.deletekey(Rsubkey)
##D 
##D     # An alternate way to get the path
##D     tk2reg.get("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "path")
##D 
##D     # Make sure that currently running apps are warned of your changes in the registry
##D     tk2reg.broadcast()
##D 
##D     # Delete temporary variables
##D     rm(list = c("Rkey", "Rsubkey"))
##D   
## End(Not run)



