### Name: tk2theme
### Title: Set or get the theme in use for themed widgets (tile)
### Aliases: tk2theme tk2theme.list tk2theme.elements
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ## Test all themes one after the other on the demo window
##D     tk2demo <- function() {
##D         tt <- tktoplevel()
##D         tktitle(tt) <- "tk2 demo"
##D 
##D         ## Change icon (under Windows)
##D         Info <- tk2ico.load(res = "information")
##D         tk2ico.set(tt, Info)
##D         tk2ico.destroy(Info)
##D 
##D         ## Add a menu with quit and all themes
##D         topMenu <- tk2menu(tt)
##D         tkconfigure(tt, menu = topMenu)
##D         fileMenu <- tk2menu(topMenu, tearoff = FALSE)
##D         tkadd(fileMenu, "command", label = "Quit",
##D                 command = function() tkdestroy(tt))
##D         tkadd(topMenu, "cascade", label = "File", menu = fileMenu)
##D         Themes <- sort(tk2theme.list())
##D         themeMenu <- tk2menu(topMenu, tearoff = FALSE)
##D         for (i in 1:length(Themes)) {
##D                 tkadd(themeMenu, "command", label = Themes[i],
##D                         command = eval(parse(text = paste("function() tk2theme(\"", Themes[i], "\")",
##D                     sep = ""))))
##D         }
##D         tkadd(topMenu, "cascade", label = "Theme", menu = themeMenu)
##D 
##D         #### TO DO: Add a toolbar
##D 
##D         ## Add a notebook with three tabs
##D         nb <- tk2notebook(tt)
##D         tcli1 <- tk2frame(nb)
##D         tkadd(nb, tcli1, text = "Tab 1")
##D         tcli2 <- tk2label(nb, text = "Nothing here.")
##D         tkadd(nb, tcli2, text = "Tab 2")
##D         tcli3 <- tk2label(nb, text = "Nothing here either.")
##D         tkadd(nb, tcli3, text = "Tab 3")
##D         tkselect(nb, tcli1)
##D         tkgrid(nb)
##D 
##D         ## Add a labelframe with new tile widgets
##D         tfrm1 <- tk2labelframe(tcli1, text = "tile widgets")
##D         tkgrid(tfrm1)
##D 
##D         # Add a label
##D         tlab <- tk2label(tfrm1, text = "This is a label... hover me to see a tooltip")
##D         tkgrid(tlab)
##D         # Define a tooltip for the label
##D         tk2tip(tlab, "A tooltip for the label \ndisplayed on two lines")
##D 
##D         # Add a button
##D         but <- tk2button(tfrm1, text = "Click me", width = 12,
##D                 command = function() tkmessageBox(title = "tk2 demo",
##D                         message = "Hello, world!", icon = "info", type = "ok"))
##D         tkgrid(but)
##D 
##D         # Add a checkbutton
##D         tcb <- tk2checkbutton(tfrm1, text = " A check button")
##D         tkgrid(tcb)
##D 
##D         # Add radio buttons
##D         rbValue <- tclVar("oranges")
##D         rb1 <- tk2radiobutton(tfrm1, text = " Apples", variable = rbValue,
##D                 value = "apples")
##D         rb2 <- tk2radiobutton(tfrm1, text = " Oranges", variable = rbValue,
##D                 value = "oranges")
##D         tkgrid(rb1, sticky = "w")
##D         tkgrid(rb2, sticky = "w")
##D 
##D         # Add a progressbar
##D         tprog <- tk2progress(tfrm1, orient = "horizontal", from = 0,  to = 100)
##D         tkgrid(tprog)
##D         tkset(tprog, 0.5)
##D 
##D         # Add a slider #### TO DO: fix command!
##D         tscal <- tk2scale(tfrm1, orient = "horizontal", from = 0, to = 100,
##D                 command = tkset(tprog, 0.2))
##D         tkgrid(tscal)
##D 
##D         ## Add a labelframe with additional widgets
##D         tfrm2 <- tk2labelframe(tcli1, text = "additional widgets", width = 50)
##D         tkgrid(tfrm2)
##D 
##D         # Add a combobox
##D         cb <- tk2combobox(tfrm2, value = "Banana")
##D         tkgrid(cb)
##D         # Fill the combobox list
##D         fruits <- c("Apple", "Orange", "Banana", "Pear")
##D         # TO DO: change this!!!
##D             #for (i in (1:4))
##D         #    tk2listinsert(cb, "end", fruits[i])
##D             tkinsert(cb, "end", "pear")
##D 
##D         tkfocus(tt)
##D         return(TRUE)
##D     }
##D 
##D     tk2demo()
##D     themes <- tk2theme.list()
##D     for (i in 1:length(themes)) {
##D         tk2theme(themes[i])
##D         Sys.sleep(2)
##D     }
##D   
## End(Not run)



