### Name: tk2widgets
### Title: A themed series of tk widget
### Aliases: tk2widgets tk2button tk2canvas tk2checkbutton tk2combobox
###   tk2entry tk2frame tk2label tk2labelframe tk2listbox tk2mclistbox
###   tk2menu tk2menubutton tk2message tk2notebook tk2panedwindow
###   tk2progress tk2radiobutton tk2scale tk2scrollbar tk2separator
###   tk2spinbox tk2table tk2text tk2tree tk2treeview
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ### A tk2notebook example
##D     tt2 <- tktoplevel()
##D     nb <- tk2notebook(tt2)
##D     tcli1 <- tk2label(nb, text = "Nothing here.")
##D     tkadd(nb, tcli1, text = "Test")
##D     tcli2 <- tk2frame(nb)
##D     but <- tk2button(tcli2, text = "Click me", command = function() tkdestroy(tt2))
##D     tkgrid(but)
##D     tkadd(nb, tcli2, text = "Button")
##D     tkselect(nb, tcli2)
##D     tkgrid(nb)
##D 
##D     ## A simple tk2panedwindow example
##D     tt2 <- tktoplevel()
##D     pw <- tk2panedwindow(tt2, orient = "vertical")
##D     lpw.1 <- tk2label(pw, text = "Panel 1")
##D     lpw.2 <- tk2label(pw, text = "Panel2")
##D     tkadd(pw, lpw.1, minsize = 100)
##D     tkadd(pw, lpw.2, minsize = 70)
##D     but <- tk2button(lpw.2, text = "OK", width = 10,
##D         command = function() tkdestroy(tt2))
##D     tkgrid(but)
##D     tkpack(pw, fill = "both", expand = "yes")
##D     # Resize the window and move the panel separator with the mouse
##D 
##D     ## A tk2combobox example
##D     tt2 <- tktoplevel()
##D     cb <- tk2combobox(tt2)
##D     tkgrid(cb)
##D     # Fill the combobox list
##D     fruits <- c("Apple", "Orange", "Banana", "Pear")
##D         # TO DO: change this!!!
##D         #for (i in (1:4))
##D     #    tk2listinsert(cb, "end", fruits[i])
##D         tkinsert(cb, "end", "pear")
##D         #tkconfigure(cb, value = "Pear")        # Set the current value for the combobox
##D     # or better: link it to a variable
##D     Fruit <- tclVar("Pear")
##D     tkconfigure(cb, textvariable = Fruit)
##D     # Create a button to get the content of the combobox
##D     but <- tk2button(tt2, text = "OK", width = 10,
##D         command = function() {tkdestroy(tt2); cat(tclvalue(Fruit), "\n")})
##D     tkgrid(but)
##D 
##D     ### An example of a tk2spinbox widget
##D     tt2 <- tktoplevel()
##D     tspin <- tk2spinbox(tt2, relief = "groove", from = 2, to = 20, increment = 2)
##D     tkgrid(tspin)
##D     #tdial <- tk2dial(tt2, from = 0, to = 20, resolution = 0.5, width = 70,
##D     #   tickinterval = 2)
##D     #tkgrid(tdial)
##D     tbut <- tk2button(tt2, text = "OK", width = 10,
##D         command = function() tkdestroy(tt2))
##D     tkgrid(tbut)
##D 
##D     ## A tk2mclistbox example
##D     tt2 <- tktoplevel()
##D     mlb <- tk2mclistbox(tt2, width = 55, resizablecolumns = TRUE)
##D     # Define the columns
##D     tk2column(mlb, "add", "name", label = "First name", width = 20)
##D     tk2column(mlb, "add", "lastname", label = "Last name", width = 20)
##D     tk2column(mlb, "add", "org", label = "Organisation", width = 15)
##D     tkgrid(mlb)
##D     # Fill the multicolumn list (we can use a vector, or a matrix of character strings)
##D     item1 <- c("Bryan", "Oackley", "ChannelPoint")
##D     items <- matrix(c("John", "Ousterhout", "Scriptics",
##D                       "Steve", "Miller", "TclTk inc."), ncol = 3, byrow = TRUE)
##D     tk2insert.multi(mlb, "end", item1)
##D     tk2insert.multi(mlb, "end", items)
##D     #### TO DO: bind events
##D     # Ex: .listbox label bind date <ButtonPress-1> "sortByDate 
##D     # See the example.tcl in .\libs\mclistbox1.02 for a more complex example
##D     # Create a button to close the dialog box
##D     but <- tk2button(tt2, text = "OK", width = 10,
##D         command = function() tkdestroy(tt2))
##D     tkgrid(but)
##D 
##D     ### A simple tk2table example
##D     myRarray <- c("Animal", "\"sphinx moth\"", "oyster",
##D                   "Type", "insect", "mollusk")
##D     dim(myRarray) <- c(3, 2)
##D     for (i in (0:2))
##D       for (j in (0:1))
##D          .Tcl(paste("set tclarray(", i, ",", j, ") ", myRarray[i+1, j+1], sep = ""))
##D     tt2 <- tktoplevel()
##D     table1 <- tk2table(tt2, variable = "tclarray", rows = "3",
##D         cols = "2", titlerows = "1", selectmode = "extended", colwidth = "25",
##D         background = "white")
##D     tkpack(table1)
##D   
## End(Not run)



