### Name: TARCH
### Title: Treshold-ARCH model
### Aliases: TARCH tarch summary.tarch print.summary.tarch
### Keywords: ts

### ** Examples

#
#Taken from tseries::garch man page
#
n <- 1100
a <- c(0.1, 0.5, 0.2)  # ARCH(2) coefficients
e <- rnorm(n)
x <- double(n)
x[1:2] <- rnorm(2, sd = sqrt(a[1]/(1.0-a[2]-a[3])))
for(i in 3:n)  # Generate ARCH(2) process
{
   x[i] <- e[i]*sqrt(a[1]+a[2]*x[i-1]^2+a[3]*x[i-2]^2)
}
x <- ts(x[101:1100])

x.tarch <- tarch(x, m=2)
summary(x.tarch)



