seqplot.ts              package:tseries              R Documentation

_P_l_o_t _T_w_o _T_i_m_e _S_e_r_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plot two time series on the same plot frame.

_U_s_a_g_e:

     seqplot.ts(x, y, colx = "black", coly = "red", typex = "l",
                typey = "l", pchx = 1, pchy = 1, ltyx = "solid",
                ltyy = "solid", oma = c(6, 0, 5, 0), ann = par("ann"),
                xlab = "Time", ylab = deparse(substitute(x)), main = NULL)

_A_r_g_u_m_e_n_t_s:

    x, y: the time series.

colx, coly: color code or name for the 'x' and 'y' series, see
          'colors', 'palette'.

typex, typey: what type of plot should be drawn for the 'x' and 'y'
          series, see 'plot'.

pchx, pchy: character or integer code for kind of points/lines for the
          'x' and 'y' series.

ltyx, ltyy: line type code for the 'x' and 'y' series, see 'lines'.

     oma: a vector giving the size of the outer margins in lines of
          text, see 'par'.

     ann: annotate the plots? See 'par'.

xlab, ylab: titles for the x and y axis.

    main: an overall title for the plot.

_D_e_t_a_i_l_s:

     Unlike 'plot.ts' the series can have different time bases, but
     they should have the same frequency. Unlike 'ts.plot' the series
     can be plotted in different styles and for multivariate 'x' and
     'y' the common variables are plotted together in a separate array
     element.

_V_a_l_u_e:

     None.

_A_u_t_h_o_r(_s):

     A. Trapletti

_S_e_e _A_l_s_o:

     'ts', 'plot.ts'

_E_x_a_m_p_l_e_s:

     data(USeconomic)
     x <- ts.union(log(M1), log(GNP), rs, rl)
     m.ar <- ar(x, method = "ols", order.max = 5)
     y <- predict(m.ar, x, n.ahead = 200, se.fit = FALSE)
     seqplot.ts(x, y)

