### Name: get.hist.quote
### Title: Download Historical Finance Data
### Aliases: get.hist.quote
### Keywords: ts

### ** Examples

if(!inherits(try(open(url("http://quote.yahoo.com")), silent = TRUE),
             "try-error")) {
  x <- get.hist.quote(instrument = "^gspc", start = "1998-01-01",
                      quote = "Close")
  plot(x)

  x <- get.hist.quote(instrument = "ibm", quote = c("Cl", "Vol"))
  plot(x, main = "International Business Machines Corp")

  spc <- get.hist.quote(instrument = "^gspc", start = "1998-01-01",
         quote = "Close")
  ibm <- get.hist.quote(instrument = "ibm",  start = "1998-01-01",
         quote = "AdjClose")
  x <- merge(spc, ibm)
  plot(x, main = "IBM vs S&P 500")

  x <- get.hist.quote(instrument = "EUR/USD", provider = "oanda",
                      start = "2004-01-01")
  plot(x, main = "EUR/USD")
}



