### Name: plotOHLC
### Title: Plot Open-High-Low-Close Bar Chart
### Aliases: plotOHLC
### Keywords: hplot ts

### ** Examples

if(!inherits(try(open(url("http://quote.yahoo.com")), silent = TRUE),
             "try-error")) {
  ## Plot OHLC bar chart for the last 'nDays' days of the instrument
  ## 'instrument'

  nDays <- 50
  instrument <- "^gspc"

  start <- strftime(as.POSIXlt(Sys.time() - nDays*24*3600),
                    format="%Y-%m-%d") 
  end <- strftime(as.POSIXlt(Sys.time()), format = "%Y-%m-%d") 
  x <- get.hist.quote(instrument = instrument, start = start, end = end,
                      retclass = "ts")

  plotOHLC(x, ylab = "price", main = instrument)
}



