### Name: int.scale.verify
### Title: Intensity-Scale Verification Model
### Aliases: int.scale.verify
### Keywords: file

### ** Examples


## simulated example
n<- 5
set.seed(10)
forecast1 <- matrix( log(rlnorm(n = (2^n *2^n) )) , nrow = 2^n)
obs1      <- matrix(log( rlnorm(n = (2^n *2^n) )) , nrow = 2^n)
int.scale.verify(forecast1, obs1, main = "Test Case")  

## real example.  Data source referenced below.

data(analysis.dat)
data(forecast.dat)

require(waveslim)
require(fields)

A<- int.scale.verify(forecast.dat, analysis.dat,
thres = c(0, 2^seq(-5,6)),  main = "NIMROD example" )

plot(A)




