discrimination.plot       package:verification       R Documentation

_D_i_s_c_r_i_m_i_n_a_t_i_o_n  _p_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     This function creates a plot of discrimination plots (overlay
     histograms).   In the context of verification, this is often used
     to compare the distribution of event and no-event forecasts.  This
     may be useful in comparing any set of observations. By default,
     boxplots of groups appear as upper marginal plots.  These may be
     surpressed.

_U_s_a_g_e:

     discrimination.plot(group.id, value, breaks = 11, main =
     "Discrimination Plot", xlim = NULL, ylim = NULL,  legend =
     FALSE, leg.txt = paste("Model", unique(group.id) ),   marginal = TRUE, cols =
     seq(2, length(unique(group.id)) + 1), xlab = "Forecast",  ... )

_A_r_g_u_m_e_n_t_s:

group.id: A vector identifying groups.  A histogram is created for each
          unique value.

   value: A vector of values corresponding to the group.id vector used
          to create the histograms

  breaks: Number of breaks in the x-axis of the histogram. The range of
          values is taken to be the range of prediction values.

    main: Title for plot.

    xlim: Range of histogram - x axis - main plot coordinates.

    ylim: Range of histogram - y axis - main plot coordinates.

  legend: Should there be a legend? Default = FALSE

 leg.txt: Legend text.  If FALSE or if a marginal plot is created, no
          legend is added.

    cols: A vector showing the colors to be used in the histograms and
          in the marginal boxplots

marginal: Should a boxplots be placed in the top margin? Defaults to
          TRUE

    xlab: Label of the x-axis on the main plot.

     ...: Additional plotting options.

_A_u_t_h_o_r(_s):

     Matt Pocernich <pocernic@rap.ucar.edu>

_E_x_a_m_p_l_e_s:

      #  A sample forecast.  

     data(disc.dat)
     discrimination.plot(disc.dat$group.id, disc.dat$frcst, main = "Default
     Plot")

     discrimination.plot(disc.dat$group.id, disc.dat$frcst,
     main = "New Labels", cex = 1.2, leg.txt = c("Low", "Med", "High" ) )

     discrimination.plot(disc.dat$group.id, disc.dat$frcst, main = "Without Marginal Plots ", marginal = FALSE)

      

